package ru.yandex.autodoc.common.out.json.builder;

import ru.yandex.autodoc.common.util.enums.IEnumResolver;

/**
 * @author avhaliullin
 */
public interface JsonAppendable {
    void appendKey(String key);

    void appendStringValue(String value);

    void appendNumericValue(String value);

    void appendBooleanValue(boolean value);

    void appendNullValue();

    void appendComma();

    void startObject();

    void endObject();

    // Нужно для рендеринга в документации объектов, представляющих map
    void endMapObject();

    void startArray();

    void endArray();

    void comment(String s);

    void commentForLastKey(String s);

    <T> PolymorphicHandler<T> polymorphic(IEnumResolver<T> er, String fieldName);

    NoTypePolymorphicHandler polymorphic();

    interface PolymorphicHandler<T> {
        JsonAppendable getParent();

        JsonAppendable withCase(T tpe);

        void endCase();
    }

    interface NoTypePolymorphicHandler {
        JsonAppendable getParent();

        JsonAppendable withCase(String caseId);

        void endCase();
    }

}