package ru.yandex.autodoc.common.out.json.builder;

/**
 * @author avhaliullin
 */
public class JsonArrayBuilder<C extends ContainerBuilder> extends ContainerBuilder {
    private final C container;

    private boolean empty = true;

    public JsonArrayBuilder(JsonAppendable appendable, C container) {
        super(appendable);
        this.container = container;
        appendable.startArray();
    }

    public JsonValueBuilder<JsonArrayBuilder<C>> element() {
        assertState(State.READY);
        state = State.FOCUS_LOOSE;

        if (!empty) {
            appendable.appendComma();
        }
        empty = false;
        return new JsonValueBuilder<>(appendable, this);
    }

    public C endArray() {
        assertState(State.READY);
        state = State.CLOSED;
        container.focusReturn();

        appendable.endArray();
        return container;
    }
}
