package ru.yandex.autodoc.common.util.enums;

import java.util.Collection;

/**
 * @author avhaliullin
 */
public class EnumResolver<T extends Enum<T>> extends AbstractEnumResolver<T, EnumResolver<T>> {
    public EnumResolver(Class<T> enumClass, T defaultValue) {
        super(enumClass, defaultValue);
    }

    public EnumResolver(Class<T> enumClass, T defaultValue, Collection<T> universe) {
        super(enumClass, defaultValue, universe);
    }

    @Override
    protected EnumResolver<T> create(Class<T> enumClass, T defaultValue, Collection<T> universe) {
        return new EnumResolver<>(enumClass, defaultValue, universe);
    }

    @Override
    public String getName(T val) {
        if (val == null) {
            return null;
        }
        return val.name();
    }
}
