package ru.yandex.autodoc.common.util.enums;

/**
 * @author avhaliullin
 */
public class EnumResolvers {
    public static <T extends Enum<T>> IEnumResolver<T> r(Class<T> enumClass, T defaultValue) {
        return new EnumResolver<>(enumClass, defaultValue);
    }

    public static <T extends Enum<T>> IEnumResolver<T> r(Class<T> enumClass) {
        return r(enumClass, null);
    }

    public static <T extends Enum<T> & IntEnum> IIntEnumResolver<T> intResolver(Class<T> enumClass, T defaultValue) {
        return new IntEnumResolver<>(enumClass, defaultValue);
    }

    public static <T extends Enum<T> & IntEnum> IIntEnumResolver<T> intResolver(Class<T> enumClass) {
        return intResolver(enumClass, null);
    }

    public static <T extends Enum<T> & NamedEnum> IEnumResolver<T> namedResolver(Class<T> enumClass, T defaultValue) {
        return new NamedEnumResolver<>(enumClass, defaultValue);
    }

    public static <T extends Enum<T> & NamedEnum> IEnumResolver<T> namedResolver(Class<T> enumClass) {
        return namedResolver(enumClass, null);
    }


    public static <T extends Enum<T> & NamedEnum & IntEnum> IIntEnumResolver<T> namedIntResolver(Class<T> enumClass, T defaultValue) {
        return new NamedIntEnumResolver<>(enumClass, defaultValue);
    }

    public static <T extends Enum<T> & NamedEnum & IntEnum> IIntEnumResolver<T> namedIntResolver(Class<T> enumClass) {
        return namedIntResolver(enumClass, null);
    }
}
