package ru.yandex.autodoc.common.util.enums;

import org.jetbrains.annotations.Contract;

import java.util.Collection;

/**
 * @author avhaliullin
 */
public interface IEnumResolver<T> {
    @Contract("null -> null")
    public T getByName(String name);

    @Contract("null -> null")
    public String getName(T val);

    public T getDefault();

    public Collection<T> listAll();

    public String join(Collection<T> values, String separator);

    public IEnumResolver<T> of(T... subset);
}
