package ru.yandex.autodoc.common.util.enums;

import org.jetbrains.annotations.Contract;

/**
 * @author avhaliullin
 */
public interface IIntEnumResolver<T> extends IEnumResolver<T> {
    @Contract("null -> null")
    public Integer getId(T value);

    @Contract("null -> fail")
    public int getPrimitiveId(T value);

    public T getById(int id);

    @Override
    public IIntEnumResolver<T> of(T... subset);
}
