package ru.yandex.autodoc.common.util.enums;

import java.util.Collection;

/**
 * @author avhaliullin
 */
public class NamedEnumResolver<T extends Enum<T> & NamedEnum> extends AbstractEnumResolver<T, NamedEnumResolver<T>> {
    public NamedEnumResolver(Class<T> enumClass, T defaultValue) {
        super(enumClass, defaultValue);
    }

    public NamedEnumResolver(Class<T> enumClass, T defaultValue, Collection<T> universe) {
        super(enumClass, defaultValue, universe);
    }

    @Override
    protected NamedEnumResolver<T> create(Class<T> enumClass, T defaultValue, Collection<T> universe) {
        return new NamedEnumResolver<>(enumClass, defaultValue, universe);
    }

    @Override
    public String getName(T val) {
        if (val == null) {
            return null;
        }
        return val.getName();
    }
}
