package ru.yandex.autodoc.common.util.enums;

import java.util.Collection;

/**
 * @author avhaliullin
 */
public class NamedIntEnumResolver<T extends Enum<T> & NamedEnum & IntEnum> extends IntEnumResolver<T> implements IIntEnumResolver<T> {

    public NamedIntEnumResolver(Class<T> enumClass, T defaultValue) {
        super(enumClass, defaultValue);
    }

    public NamedIntEnumResolver(Class<T> enumClass, T defaultValue, Collection<T> universe) {
        super(enumClass, defaultValue, universe);
    }

    @Override
    public String getName(T val) {
        if (val == null) {
            return null;
        }
        return val.getName();
    }
}
