package ru.yandex.autodoc.wmtools.errors.view;

import ru.yandex.wmtools.common.error.ExtraTagInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.error.UserException;

import java.util.ArrayList;

/**
 * @author avhaliullin
 */
public class ErrorsWrapUtil {
    public static WrappedError wrapJsonInternalException(InternalException e) {
        return new AbstractErrorWrapper(e.getProblem(), null, e.getMessage(), null, e, e.getExtraParams());
    }

    public static WrappedError wrapJsonUserException(UserException e) {
        return new AnnotatedUserExceptionWrapper(e);
    }

    public static WrappedError wrapJsonUnknownException(Throwable e) {
        return new AbstractErrorWrapper(InternalProblem.INTERNAL_PROBLEM, null, e.getMessage(), null, e, new ArrayList<ExtraTagInfo>());
    }

    public static WrappedError wrapJsonError(Throwable t) {
        if (t instanceof InternalException) {
            return wrapJsonInternalException((InternalException) t);
        } else if (t instanceof UserException) {
            return wrapJsonUserException((UserException) t);
        } else {
            return wrapJsonUnknownException(t);
        }
    }

}
