package ru.yandex.autodoc.wmtools.out.json;

import ru.yandex.autodoc.common.out.json.JsonConvertableUtils;
import ru.yandex.autodoc.common.out.json.builder.ContainerBuilder;
import ru.yandex.autodoc.common.out.json.builder.JsonValueBuilder;

/**
 * @author avhaliullin
 */
public abstract class JsonConvertableAdapterImpl implements JsonConvertableAdapter {
    @Override
    public void toJson(StringBuilder storage) {
        writeValue(JsonConvertableUtils.createValueBuilder(storage));
    }


    public JsonConvertableWithKeyAdapter withKey(final String key) {
        return new JsonConvertableWithKeyAdapter() {
            @Override
            public String getKey() {
                return key;
            }

            @Override
            public void toJson(StringBuilder stringBuilder) {
                JsonConvertableAdapterImpl.this.toJson(stringBuilder);
            }

            @Override
            public <C extends ContainerBuilder> C writeValue(JsonValueBuilder<C> builder) {
                return JsonConvertableAdapterImpl.this.writeValue(builder);
            }
        };
    }
}
