package ru.yandex.autodoc.wmtools.out.json;

import ru.yandex.autodoc.common.out.json.JsonObjectWriter;
import ru.yandex.autodoc.common.out.json.builder.ContainerBuilder;
import ru.yandex.autodoc.common.out.json.builder.JsonObjectBuilder;
import ru.yandex.autodoc.common.out.json.builder.JsonValueBuilder;

/**
 * Стандартный wrapper для заворачивания Java-объектов в JSON-объекты
 *
 * @author avhaliullin
 */
public abstract class JsonObjectWrapper<T> extends JsonWrapper<T> implements JsonObjectWriter {
    public JsonObjectWrapper(T data) {
        super(data);
    }

    @Override
    public <C extends ContainerBuilder> C doWriteValue(JsonValueBuilder<C> builder) {
        return doWriteObject(builder.valueObject()).endObject();
    }

    @Override
    public <C extends ContainerBuilder> JsonObjectBuilder<C> writeObject(JsonObjectBuilder<C> builder) {
        if (data != null) {
            return doWriteObject(builder);
        } else {
            return builder;
        }
    }

    public abstract <C extends ContainerBuilder> JsonObjectBuilder<C> doWriteObject(JsonObjectBuilder<C> builder);
}
