package ru.yandex.autodoc.wmtools.out.json;

import ru.yandex.autodoc.common.out.json.JsonConvertableUtils;
import ru.yandex.autodoc.common.out.json.builder.ContainerBuilder;
import ru.yandex.autodoc.common.out.json.builder.JsonValueBuilder;

/**
 * Стандартный wrapper для заворачивания Java-объекта в любое JSON-значение (объект, число, массив и т.п.)
 *
 * @author avhaliullin
 */
public abstract class JsonWrapper<T> extends JsonConvertableAdapterImpl implements JsonConvertableAdapter {
    protected final T data;

    public JsonWrapper(T data) {
        this.data = data;
    }

    @Override
    public void toJson(StringBuilder stringBuilder) {
        writeValue(JsonConvertableUtils.createValueBuilder(stringBuilder));
    }

    @Override
    public <C extends ContainerBuilder> C writeValue(JsonValueBuilder<C> builder) {
        if (data == null) {
            return builder.valueNull();
        } else {
            return doWriteValue(builder);
        }
    }

    public abstract <C extends ContainerBuilder> C doWriteValue(JsonValueBuilder<C> builder);
}
