package ru.yandex.autodoc.wmtools.out.json;

import ru.yandex.autodoc.common.doc.result.MethodResult;
import ru.yandex.autodoc.common.out.json.builder.ContainerBuilder;
import ru.yandex.autodoc.common.out.json.builder.JsonObjectBuilder;
import ru.yandex.autodoc.common.out.json.builder.JsonValueBuilder;

import java.util.Collection;

/**
 * @author avhaliullin
 */
public class SimpleDocumentedJsonResult extends MethodResult.DocumentedJsonResult {
    private final Collection<JsonConvertableWithKeyAdapter> wrappers;

    public SimpleDocumentedJsonResult(Collection<JsonConvertableWithKeyAdapter> wrappers) {
        this.wrappers = wrappers;
    }

    @Override
    public <C extends ContainerBuilder> C writeValue(JsonValueBuilder<C> builder) {
        JsonObjectBuilder<C> objectBuilder = builder.valueObject();
        for (JsonConvertableWithKeyAdapter convertable : wrappers) {
            objectBuilder = convertable.writeValue(objectBuilder.key(convertable.getKey()));
        }
        return objectBuilder.endObject();
    }
}
