package ru.yandex.autodoc.wmtools.params;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public class QueryContext {
    private final ServRequest request;
    private final ServResponse response;
    private final List<Throwable> errors;

    public QueryContext(ServRequest request, ServResponse response, List<Throwable> errors) {
        this.request = request;
        this.response = response;
        this.errors = errors;
    }

    public ServRequest getRequest() {
        return request;
    }

    public ServResponse getResponse() {
        return response;
    }

    public boolean hasErrors() {
        return !errors.isEmpty();
    }

    public void addError(Throwable error) {
        errors.add(error);
    }

    /**
     * Errors doesn't matter here
     *
     * @return
     */
    public QueryContext safeContext() {
        return new QueryContext(request, response, new ArrayList<Throwable>());
    }

    public QueryContext childContext() {
        final QueryContext self = this;
        return new QueryContext(request, response, new ArrayList<Throwable>()) {
            @Override
            public void addError(Throwable error) {
                super.addError(error);
                self.addError(error);
            }
        };
    }
}
