package ru.yandex.autodoc.wmtools.params.fetch;


import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.common.doc.params.ParamType;
import org.apache.commons.lang.mutable.MutableBoolean;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.autodoc.wmtools.params.QueryContext;

/**
 * @author avhaliullin
 */
public class ParamHolder<T> {
    protected final String name;
    protected final T value;
    protected final QueryContext context;
    private MutableBoolean hasError;
    private final String stringValue;

    public ParamHolder(String name, T value, QueryContext context, boolean hasError, String stringValue) {
        this(name, value, context, new MutableBoolean(hasError), stringValue);
    }

    private ParamHolder(String name, T value, QueryContext context, MutableBoolean hasError, String stringValue) {
        this.name = name;
        this.value = value;
        this.context = context;
        this.hasError = hasError;
        this.stringValue = stringValue;
    }

    public T getValue() {
        return value;
    }

    public boolean hasError() {
        return hasError.booleanValue();
    }

    public <B> ParamHolder<B> map(B value) {
        return new ParamHolder<>(name, value, context, hasError, stringValue);
    }

    public void addError(UserException error) {
        if (!hasError()) {
            context.addError(error);
            hasError.setValue(true);
        }
    }

    public String getName() {
        return name;
    }

    public String getStringValue() {
        return stringValue;
    }

    public void errorRequiredParamMissed() {
        addError(CommonUserException.createRequiredParamMissed(name));
    }

    public void errorIllegalValueType(ParamType type) {
        addError(CommonUserException.createIllegalValueType(name, stringValue, type));
    }

    public void errorIllegalParamValue(String stringValue, String extraInfo, UserException cause) {
        addError(CommonUserException.createIllegalParamValue(name, stringValue, extraInfo, cause));
    }

    public void errorTooManyValues(int maxValues, int actualValues) {
        addError(CommonUserException.createTooManyValues(name, maxValues, actualValues));
    }

    public void errorTooFewValues(int minValues, int actualValues) {
        addError(CommonUserException.createTooFewValues(name, minValues, actualValues));
    }

    public void errorValueTooShort(int minLength) {
        addError(CommonUserException.createValueTooShort(name, stringValue, minLength));
    }

    public void errorValueTooLong(int maxLength) {
        addError(CommonUserException.createValueTooLong(name, stringValue, maxLength));
    }

    public void errorMalformedURL() {
        addError(CommonUserException.createMalformedUrl(name, stringValue));
    }
}
