package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractParamView;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.ErrorListener;

import java.util.ArrayList;

/**
 * @author avhaliullin
 */
public class BooleanViewSingle extends AbstractParamView<Boolean> {

    public BooleanViewSingle(ParamsDocRegistrar registrar, String name, boolean required, Boolean defaultValue, String desc) {
        super(registrar, name, ParamType.BOOLEAN, required, required, defaultValue, desc, new ArrayList<ExtraInfoItem>());
    }

    @Override
    protected Boolean doFetch(String value, ErrorListener errorListener) {
        if ("true".equals(value)) {
            return true;
        } else {
            if (required) {
                if ("false".equals(value)) {
                    return false;
                } else {
                    errorListener.error(CommonUserException.createIllegalValueType(name, value, ParamType.BOOLEAN));
                    return defaultValue;
                }
            } else {
                return defaultValue;
            }
        }
    }
}