package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractParamView;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.ErrorListener;

import java.util.ArrayList;
import java.util.regex.Pattern;

/**
 * @author avhaliullin
 */
public class ColorViewSingle extends AbstractParamView<String> {
    private static final Pattern COLOR_REGEX = Pattern.compile(
            "[#][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]");
    private final boolean allowTransparent;

    public ColorViewSingle(ParamsDocRegistrar registrar, String name, boolean required, boolean allowTransparent,
                           String defaultValue, String desc) {
        super(registrar, name, ParamType.color(allowTransparent), true, required, defaultValue, desc, new ArrayList<ExtraInfoItem>());
        this.allowTransparent = allowTransparent;
    }


    @Override
    protected String doFetch(String value, ErrorListener errorListener) {
        value = value.trim();
        if (allowTransparent && "transparent".equalsIgnoreCase(value)) {
            return value.toLowerCase();
        }
        if (!COLOR_REGEX.matcher(value).matches()) {
            errorListener.error(CommonUserException.createIllegalValueType(name, value, type));
        }
        return value;
    }
}
