package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractParamView;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.ErrorListener;
import ru.yandex.autodoc.common.util.enums.IEnumResolver;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;

import java.util.ArrayList;

/**
 * @author avhaliullin
 */
public class EnumViewSingle<T extends Enum<T>> extends AbstractParamView<T> {
    private final IEnumResolver<T> resolver;

    public EnumViewSingle(ParamsDocRegistrar registrar, String name, IEnumResolver<T> resolver, boolean required, T defaultValue, String desc) {
        super(registrar, name, ParamType.enumName(resolver), true, required, defaultValue, resolver.getName(defaultValue),
                desc, new ArrayList<ExtraInfoItem>());
        this.resolver = resolver;
    }

    @Override
    protected T doFetch(String value, ErrorListener errorListener) {
        T res = resolver.getByName(value);
        if (res == null) {
            errorListener.error(CommonUserException.createIllegalValueType(name, value, type));
            return defaultValue;
        } else {
            return res;
        }
    }
}