package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.common.util.text.Parsers;
import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractMultiParamView;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.ErrorListener;

import java.util.ArrayList;

/**
 * @author avhaliullin
 */
public class IntegerViewMultiple extends AbstractMultiParamView<Integer> {

    public IntegerViewMultiple(ParamsDocRegistrar registrar, String name, boolean required, Integer minValues, Integer maxValues, String desc) {
        super(registrar, name, ParamType.INTEGER, required, new ArrayList<ExtraInfoItem>(), minValues, maxValues, false, desc);
    }

    @Override
    protected Integer doFetch(String value, ErrorListener errorListener) {
        if (Parsers.isInteger(value)) {
            return Integer.parseInt(value);
        } else {
            errorListener.error(CommonUserException.createIllegalValueType(name, value, type));
            return null;
        }
    }

}