package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.common.util.text.Parsers;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractParamView;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.ErrorListener;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public class IntegerViewSingle extends AbstractParamView<Integer> {
    private final Integer minValue;
    private final Integer maxValue;

    public IntegerViewSingle(ParamsDocRegistrar registrar, String name, boolean required, Integer minValue, Integer maxValue, Integer defaultValue, String desc) {
        super(registrar, name, ParamType.INTEGER, true, required, defaultValue, desc, makeExtras(minValue, maxValue));
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    protected Integer doFetch(String value, ErrorListener errorListener) {
        if (Parsers.isInteger(value)) {
            Integer res = Integer.parseInt(value);
            if (minValue != null && res < minValue) {
                errorListener.error(CommonUserException.createIllegalParamValue(name, value, "Min value for this parameter is " + minValue + ", actually have " + res));
            }
            if (maxValue != null && res > maxValue) {
                errorListener.error(CommonUserException.createIllegalParamValue(name, value, "Max value for this parameter is " + maxValue + ", actually have " + res));
            }
            return res;
        } else {
            errorListener.error(CommonUserException.createIllegalValueType(name, value, type));
            return defaultValue;
        }
    }

    private static List<ExtraInfoItem> makeExtras(Integer minValue, Integer maxValue) {
        List<ExtraInfoItem> res = new ArrayList<>();
        if (minValue != null) {
            res.add(ExtraInfoItem.createSimple("Min value: " + minValue));
        }
        if (maxValue != null) {
            res.add(ExtraInfoItem.createSimple("Max value: " + maxValue));
        }
        return res;
    }
}