package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.wmtools.params.fetch.MultiParamView;
import ru.yandex.autodoc.wmtools.params.fetch.ParamView;
import ru.yandex.autodoc.wmtools.params.fetch.json.JsonArrayView;
import ru.yandex.autodoc.wmtools.params.fetch.json.JsonValueView;
import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;
import ru.yandex.autodoc.wmtools.params.fetch.ParamViews;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractMultiParamViewBuilder;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public class JsonArrayViewBuilder<T> extends AbstractMultiParamViewBuilder<JsonArrayViewBuilder<T>> {
    private final JsonValueView<T, ?> elementView;

    public JsonArrayViewBuilder(String paramName, JsonValueView<T, ?> valueView) {
        super(paramName);
        elementView = valueView;
    }

    public MultiParamView<T> build(ParamsDocRegistrar registrar, String desc) {
        ParamView<List<ParamHolder<T>>> delegate = ParamViews.jsonView(registrar, paramName, required,
                new JsonArrayView<>(elementView, minValues, maxValues), new ArrayList<ParamHolder<T>>(), desc);
        return new MultiParamViewAdapter<>(delegate);
    }

    @Override
    protected JsonArrayViewBuilder<T> self() {
        return this;
    }
}
