package ru.yandex.autodoc.wmtools.params.fetch.impl;

import com.fasterxml.jackson.databind.JsonNode;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.params.fetch.json.JsonValueView;
import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.common.doc.params.ParamDescriptor;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.wmtools.params.QueryContext;
import ru.yandex.autodoc.wmtools.params.fetch.ParamFetchUtils;
import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;
import ru.yandex.autodoc.wmtools.params.fetch.ParamView;
import ru.yandex.autodoc.wmtools.params.fetch.json.JsonValueContext;
import ru.yandex.autodoc.wmtools.util.JsonUtil;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @author avhaliullin
 */
public class JsonViewSingle<T> implements ParamView<T> {
    protected final String name;
    protected final boolean required;
    protected final T defaultValue;
    protected final String desc;
    private final JsonValueView<T, ?> jsonView;

    public JsonViewSingle(ParamsDocRegistrar registrar, String name, boolean required, JsonValueView<T, ?> jsonView, T defaultValue, String desc) {
        this.name = name;
        this.required = required;
        this.defaultValue = defaultValue;
        this.desc = desc;
        this.jsonView = jsonView;
        registrar.register(new ParamDescriptor(name, required, ParamType.JSON, null, desc, makeExtraInfos(jsonView)));
    }

    private static List<ExtraInfoItem> makeExtraInfos(JsonValueView<?, ?> view) {
        List<ExtraInfoItem> res = new ArrayList<>();
        res.add(ExtraInfoItem.createSpoiler("JSON", ExtraInfoItem.createJsonInfo(view.getExample(new HashSet<JsonValueView>()))));
        for (String rootExtraInfo : view.getExtraInfo()) {
            res.add(ExtraInfoItem.createSimple(rootExtraInfo));
        }
        return res;
    }

    @Override
    public ParamHolder<T> fetch(QueryContext context) {
        String valueString = ParamFetchUtils.getNullableParam(context.getRequest(), name);
        if (valueString != null) {
            valueString = valueString.trim();
        }
        if (valueString == null || valueString.isEmpty()) {
            if (required) {
                context.addError(CommonUserException.createRequiredParamMissed(name));
            }
            return new ParamHolder<>(valueString, defaultValue, context, required, valueString);
        }
        try {
            JsonNode node = JsonUtil.readTree(valueString);
            QueryContext childContext = context.childContext();
            T res = jsonView.fetchValue(new JsonValueContext(childContext, name, node, "", null), null);
            return new ParamHolder<>(name, res, context, childContext.hasErrors(), valueString);
        } catch (InternalException e) {
            context.addError(CommonUserException.createIllegalValueType(name, valueString, ParamType.JSON));
            return new ParamHolder<>(name, defaultValue, context, true, valueString);
        }
    }

    @Override
    public T fetchValue(QueryContext context) {
        return fetch(context).getValue();
    }
}