package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.ErrorListener;
import ru.yandex.common.util.text.Parsers;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractParamView;

import java.util.ArrayList;

/**
 * @author avhaliullin
 */
public class LongViewSingle extends AbstractParamView<Long> {

    public LongViewSingle(ParamsDocRegistrar registrar, String name, boolean required, Long defaultValue, String desc) {
        super(registrar, name, ParamType.INTEGER, true, required, defaultValue, desc, new ArrayList<ExtraInfoItem>());
    }

    @Override
    protected Long doFetch(String value, ErrorListener errorListener) {
        if (Parsers.isLong(value)) {
            return Long.parseLong(value);
        } else {
            errorListener.error(CommonUserException.createIllegalValueType(name, value, type));
            return defaultValue;
        }
    }
}