package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.wmtools.params.fetch.MultiParamView;
import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;
import ru.yandex.autodoc.wmtools.params.fetch.ParamView;
import ru.yandex.autodoc.wmtools.params.QueryContext;
import ru.yandex.autodoc.wmtools.params.fetch.ParamUtils;

import java.util.List;

/**
 * @author avhaliullin
 */
public class MultiParamViewAdapter<T> implements MultiParamView<T> {
    private final ParamView<List<ParamHolder<T>>> delegate;

    public MultiParamViewAdapter(ParamView<List<ParamHolder<T>>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ParamHolder<List<ParamHolder<T>>> fetch(QueryContext context) {
        return delegate.fetch(context);
    }

    @Override
    public List<T> fetchValues(QueryContext context) {
        return ParamUtils.unwrap(fetch(context));
    }
}
