package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.wmtools.params.fetch.MultiParamView;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractMultiStringViewBuilder;

/**
 * @author avhaliullin
 */
public class MultiStringBuilder extends AbstractMultiStringViewBuilder<MultiStringBuilder> {
    private boolean skipNull = false;
    private boolean emptyAsNull = false;

    public MultiStringBuilder(String paramName) {
        super(paramName);
    }

    @Override
    protected MultiStringBuilder self() {
        return this;
    }

    public MultiStringBuilder skipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public MultiStringBuilder skipNull() {
        return skipNull(true);
    }

    public MultiStringBuilder emptyAsNull(boolean emptyAsNull) {
        this.emptyAsNull = emptyAsNull;
        return this;
    }

    public MultiStringBuilder emptyAsNull() {
        return emptyAsNull(true);
    }

    public MultiParamView<String> build(ParamsDocRegistrar registrar, String desc) {
        return new StringViewMultiple(registrar, paramName, required, minValues, maxValues, minLength, maxLength, trim,
                normalizeSpaces, skipNull, emptyAsNull, escapeHTML, desc);
    }
}
