package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractParamView;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.ErrorListener;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

/**
 * @author avhaliullin
 */
public class OldDateViewSingle extends AbstractParamView<Date> {
    private final DateFormat dateFormat;

    public OldDateViewSingle(ParamsDocRegistrar registrar, String name, DateFormat dateFormat, boolean required, Date defaultValue, String desc) {
        super(registrar, name, ParamType.date(dateFormat), true, required, defaultValue, desc, new ArrayList<ExtraInfoItem>());
        this.dateFormat = dateFormat;
    }

    @Override
    protected Date doFetch(String value, ErrorListener errorListener) {
        try {
            return dateFormat.parse(value);
        } catch (ParseException e) {
            errorListener.error(CommonUserException.createIllegalValueType(name, value, type));
            return defaultValue;
        }
    }
}