package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.wmtools.params.fetch.MultiParamView;
import ru.yandex.autodoc.wmtools.params.fetch.impl.common.AbstractMultiStringViewBuilder;

/**
 * @author avhaliullin
 */
public class SeparatedStringViewBuilder extends AbstractMultiStringViewBuilder<SeparatedStringViewBuilder> {
    private String delimiters = "\n";
    private boolean skipEmpty = false;
    private boolean required = false;

    public SeparatedStringViewBuilder(String paramName) {
        super(paramName);
    }

    public SeparatedStringViewBuilder skipEmpty(boolean skipEmpty) {
        this.skipEmpty = skipEmpty;
        return this;
    }

    public SeparatedStringViewBuilder skipEmpty() {
        return skipEmpty(true);
    }

    public SeparatedStringViewBuilder delimiters(String delimiters) {
        this.delimiters = delimiters;
        return this;
    }

    public MultiParamView<String> build(ParamsDocRegistrar registrar, String desc) {
        return new PseudoMultiParamView(registrar, paramName, required, delimiters, minValues, maxValues, minLength,
                maxLength, trim, normalizeSpaces, skipEmpty, escapeHTML, desc);
    }

    @Override
    protected SeparatedStringViewBuilder self() {
        return this;
    }
}
