package ru.yandex.autodoc.wmtools.params.fetch.impl;

import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.wmtools.params.fetch.ParamView;

/**
 * @author avhaliullin
 */
public class StringViewBuilder {
    private final String paramName;
    private boolean required = false;
    private boolean trim = false;
    private boolean normalizeSpaces = false;
    private boolean escapeHTML = false;
    private boolean emptyAsNull = false;
    private Integer minLength;
    private Integer maxLength;
    private String defaultValue;


    public StringViewBuilder(String paramName) {
        this.paramName = paramName;
    }

    public StringViewBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public StringViewBuilder required() {
        return required(true);
    }

    public StringViewBuilder trim(boolean trim) {
        this.trim = trim;
        return this;
    }

    public StringViewBuilder trim() {
        return trim(true);
    }

    public StringViewBuilder normalizeSpaces(boolean normalizeSpaces) {
        this.normalizeSpaces = normalizeSpaces;
        return this;
    }

    public StringViewBuilder normalizeSpaces() {
        return normalizeSpaces(true);
    }

    public StringViewBuilder normalizeAndTrimSpaces() {
        normalizeSpaces();
        return trim();
    }

    public StringViewBuilder escapeHTML(boolean escapeHTML) {
        this.escapeHTML = escapeHTML;
        return this;
    }

    public StringViewBuilder escapeHTML() {
        return escapeHTML(true);
    }

    public StringViewBuilder emptyAsNull(boolean emptyAsNull) {
        this.emptyAsNull = emptyAsNull;
        return this;
    }

    public StringViewBuilder emptyAsNull() {
        return emptyAsNull(true);
    }

    public StringViewBuilder minLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public StringViewBuilder maxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public StringViewBuilder defaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public StringViewBuilder forUrl() {
        return emptyAsNull().trim();
    }

    public StringViewBuilder notEmpty() {
        return emptyAsNull().required();
    }

    public ParamView<String> build(ParamsDocRegistrar registrar, String desc) {
        return new StringViewSingle(registrar, paramName, required, defaultValue, minLength, maxLength, trim, normalizeSpaces, emptyAsNull, escapeHTML, desc);
    }
}