package ru.yandex.autodoc.wmtools.params.fetch.impl.common;


import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;
import ru.yandex.autodoc.wmtools.params.fetch.ParamView;
import ru.yandex.autodoc.wmtools.params.QueryContext;
import ru.yandex.autodoc.wmtools.params.fetch.MapParamView;

import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public abstract class AbstractMapParamView<K, V> implements MapParamView<K, V> {
    protected final String name;
    protected final ParamType keyType;
    protected final ParamType valueType;
    protected final String desc;
    protected final Integer minValues;
    protected final Integer maxValues;
    protected final ParamView<V> valueView;

    public AbstractMapParamView(String name, ParamType keyType, ParamType valueType, ParamView<V> valueView, Integer minValues, Integer maxValues, String desc) {
        this.name = name;
        this.keyType = keyType;
        this.valueType = valueType;
        this.desc = desc;
        this.minValues = minValues;
        this.maxValues = maxValues;
        this.valueView = valueView;
    }

    @Override
    public Map<K, ParamHolder<V>> fetch(QueryContext context) {
        Map<K, ParamHolder<V>> res = new HashMap<>();
        Map<String, String> params = context.getRequest().getParams();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String keyString = entry.getKey();
            if (keyString.startsWith(name)) {
                String suffix = keyString.substring(name.length());
                K key = doFetchKey(suffix);
                if (key != null) {
                    res.put(key, valueView.fetch(context));
                }
            }
        }
        return res;
    }

    @Override
    public Map<K, V> fetchValues(QueryContext context) {
        Map<K, ParamHolder<V>> map = fetch(context);
        Map<K, V> res = new HashMap<>();
        for (Map.Entry<K, ParamHolder<V>> entry : map.entrySet()) {
            res.put(entry.getKey(), entry.getValue().getValue());
        }
        return res;
    }

    protected abstract K doFetchKey(String value);
}
