package ru.yandex.autodoc.wmtools.params.fetch.impl.common;

/**
 * @author avhaliullin
 */
public abstract class AbstractMultiParamViewBuilder<B> {
    protected final String paramName;
    protected boolean required = false;
    protected Integer minValues = null;
    protected Integer maxValues = null;

    protected AbstractMultiParamViewBuilder(String paramName) {
        this.paramName = paramName;
    }

    public B minValues(int minValues) {
        this.minValues = minValues;
        return self();
    }

    public B maxValues(int maxValues) {
        this.maxValues = maxValues;
        return self();
    }

    public B required(boolean required) {
        this.required = required;
        return self();
    }

    public B required() {
        return required(true);
    }

    protected abstract B self();
}
