package ru.yandex.autodoc.wmtools.params.fetch.impl.common;

/**
 * @author avhaliullin
 */
public abstract class AbstractMultiStringViewBuilder<B> extends AbstractMultiParamViewBuilder<B> {
    protected Integer minLength = null;
    protected Integer maxLength = null;
    protected boolean trim = false;
    protected boolean normalizeSpaces = false;
    protected boolean escapeHTML = false;

    public AbstractMultiStringViewBuilder(String paramName) {
        super(paramName);
    }

    public B minLength(int minLength) {
        this.minLength = minLength;
        return self();
    }

    public B maxLength(int maxLength) {
        this.maxLength = maxLength;
        return self();
    }

    public B trim(boolean trim) {
        this.trim = trim;
        return self();
    }

    public B trim() {
        return trim(true);
    }

    public B escapeHTML(boolean escapeHTML) {
        this.escapeHTML = escapeHTML;
        return self();
    }

    public B escapeHTML() {
        return escapeHTML(true);
    }

    public B normalizeSpaces(boolean normalizeSpaces) {
        this.normalizeSpaces = normalizeSpaces;
        return self();
    }

    public B normalizeSpaces() {
        return normalizeSpaces(true);
    }

    public B normalizeAndTrimSpaces() {
        normalizeSpaces();
        return trim();
    }
}
