package ru.yandex.autodoc.wmtools.params.fetch.impl.common;

import ru.yandex.autodoc.common.doc.ExtraInfoItem;
import ru.yandex.autodoc.common.doc.abstracts.ParamsDocRegistrar;
import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.wmtools.params.fetch.ParamView;
import ru.yandex.autodoc.common.doc.params.ParamDescriptor;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.wmtools.params.QueryContext;
import ru.yandex.autodoc.wmtools.params.fetch.ParamFetchUtils;
import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;

import java.util.List;

/**
 * @author avhaliullin
 */
public abstract class AbstractParamView<T> implements ParamView<T> {
    protected final String name;
    protected final ParamType type;
    protected final boolean required;
    protected final T defaultValue;
    protected final boolean emptyAsNull;

    protected AbstractParamView(ParamsDocRegistrar registrar, String name, ParamType type, boolean emptyAsNull, boolean required,
                                T defaultValue, String desc, List<ExtraInfoItem> extraInfos) {
        this(registrar, name, type, emptyAsNull, required, defaultValue, defaultValue == null ? null : defaultValue.toString(), desc, extraInfos);
    }

    protected AbstractParamView(ParamsDocRegistrar registrar, String name, ParamType type, boolean emptyAsNull, boolean required,
                                T defaultValue, String defaultValueString, String desc, List<ExtraInfoItem> extraInfos) {
        this.name = name;
        this.type = type;
        this.emptyAsNull = emptyAsNull;
        this.required = required;
        this.defaultValue = defaultValue;
        registrar.register(new ParamDescriptor(name, required, type, defaultValueString, desc, extraInfos));
    }

    public T fetchValue(QueryContext context) {
        return fetch(context).getValue();
    }

    public ParamHolder<T> fetch(QueryContext context) {
        String value = ParamFetchUtils.getNullableParam(context.getRequest(), name);
        if (value != null && emptyAsNull && value.isEmpty()) {
            value = null;
        }
        ErrorListener errorListener = new ErrorListener();
        T res;
        if (value != null) {
            res = doFetch(value, errorListener);
        } else {
            res = defaultValue;
            if (required) {
                errorListener.error(CommonUserException.createRequiredParamMissed(name));
            }
        }
        if (errorListener.hasError()) {
            context.addError(errorListener.getError());
        }
        return new ParamHolder<>(name, res, context, errorListener.hasError(), value);
    }

    protected abstract T doFetch(String value, ErrorListener errorListener);
}
