package ru.yandex.autodoc.wmtools.params.fetch.json;

import com.fasterxml.jackson.databind.JsonNode;
import ru.yandex.autodoc.wmtools.params.QueryContext;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public class JsonArrayContext extends JsonContainerContext {
    public JsonArrayContext(QueryContext queryContext, String paramName, JsonNode node, String jsonPath, JsonContainerContext parent) {
        super(queryContext, paramName, node, jsonPath, parent);
    }

    private String jsonArrayItemPath(int index) {
        return jsonPath + "[" + index + "]";
    }

    public List<JsonValueContext> getItems() {
        if (isNull()) {
            return null;
        }
        List<JsonValueContext> result = new ArrayList<>();
        for (int i = 0; i < node.size(); i++) {
            result.add(new JsonValueContext(queryContext, paramName, node.get(i), jsonArrayItemPath(i), this));
        }
        return result;
    }
}
