package ru.yandex.autodoc.wmtools.params.fetch.json;

import com.fasterxml.jackson.databind.JsonNode;
import ru.yandex.autodoc.wmtools.params.QueryContext;

/**
 * @author avhaliullin
 */
public abstract class JsonContainerContext extends JsonValueContext {
    private boolean childrenHaveErrors;

    public JsonContainerContext(QueryContext queryContext, String paramName, JsonNode node, String jsonPath, JsonContainerContext parent) {
        super(queryContext, paramName, node, jsonPath, parent);
    }

    public void reportChildError() {
        if (!childrenHaveErrors) {
            childrenHaveErrors = true;
            if (parent != null) {
                parent.reportChildError();
            }
        }
    }

    public boolean isChildrenHaveErrors() {
        return childrenHaveErrors;
    }
}
