package ru.yandex.autodoc.wmtools.params.fetch.json;

import com.fasterxml.jackson.databind.JsonNode;
import ru.yandex.autodoc.wmtools.errors.CommonUserException;
import ru.yandex.autodoc.wmtools.params.QueryContext;

/**
 * @author avhaliullin
 */
public class JsonObjectContext extends JsonContainerContext {
    public JsonObjectContext(QueryContext queryContext, String paramName, JsonNode node, String jsonPath, JsonContainerContext parent) {
        super(queryContext, paramName, node, jsonPath, parent);
    }

    protected String jsonPathWithField(String fieldName) {
        return jsonPath + "." + fieldName;
    }

    public JsonValueContext getField(String fieldName, boolean required) {
        if (isNull()) {
            return null;
        }
        JsonNode field = node.get(fieldName);
        JsonValueContext res = new JsonValueContext(queryContext, paramName, field, jsonPathWithField(fieldName), this);

        if (required && (field == null || field.isNull())) {
            res.addError(CommonUserException.createRequiredParamMissed(jsonParamName(jsonPathWithField(fieldName))));
        }

        return res;
    }
}
