package ru.yandex.autodoc.wmtools.params.fetch.json;

import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;
import ru.yandex.autodoc.common.out.json.JsonValueWriter;

import java.util.List;
import java.util.Set;

/**
 * @author avhaliullin
 */
public interface JsonValueView<T, I> {
    public ParamHolder<T> fetch(JsonValueContext context, I injected);

    public T fetchValue(JsonValueContext context, I injected);

    /**
     * @param usedViews Используется, чтобы избежать рекурсивного документирования циклически зависимых классов
     * @return
     */
    public JsonValueWriter getExample(Set<JsonValueView> usedViews);

    public List<String> getExtraInfo();
}
