package ru.yandex.autodoc.wmtools.params.fetch.json;

import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;
import ru.yandex.autodoc.wmtools.params.fetch.ParamUtils;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SimpleArrayFieldView<T> extends SimpleFieldView<List<ParamHolder<T>>> {
    private final JsonValueView<List<ParamHolder<T>>, ?> view;
    private final String fieldName;
    private final boolean required;

    public SimpleArrayFieldView(JsonValueView<List<ParamHolder<T>>, ?> view, String fieldName, boolean required) {
        this.view = view;
        this.fieldName = fieldName;
        this.required = required;
    }

    public List<T> fetchUnwrapped(JsonObjectContext context) {
        return ParamUtils.unwrap(fetchValue(context));
    }

    @Override
    public ParamHolder<List<ParamHolder<T>>> fetch(JsonObjectContext context, Void injected) {
        return view.fetch(context.getField(fieldName, required), null);
    }
}
