package ru.yandex.autodoc.wmtools.params.fetch.json.primitive;

import ru.yandex.autodoc.wmtools.params.fetch.json.JsonObjectContext;
import ru.yandex.autodoc.wmtools.params.fetch.json.SimpleFieldView;
import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;

/**
 * @author avhaliullin
 */
public class BooleanFieldView extends SimpleFieldView<Boolean> {
    private final SimpleFieldView<Boolean> delegate;

    public BooleanFieldView(SimpleFieldView<Boolean> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ParamHolder<Boolean> fetch(JsonObjectContext context, Void injected) {
        return delegate.fetch(context, injected);
    }

    public boolean fetchValue(JsonObjectContext context, boolean defaultValue) {
        Boolean res = fetchValue(context);
        return res == null ? defaultValue : res;
    }
}
