package ru.yandex.autodoc.wmtools.params.fetch.json.primitive;

import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;
import ru.yandex.autodoc.wmtools.params.fetch.json.JsonObjectContext;
import ru.yandex.autodoc.wmtools.params.fetch.json.SimpleFieldView;

/**
 * @author avhaliullin
 */
public class IntFieldView extends SimpleFieldView<Integer> {
    private final SimpleFieldView<Integer> delegate;

    public IntFieldView(SimpleFieldView<Integer> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ParamHolder<Integer> fetch(JsonObjectContext context, Void injected) {
        return delegate.fetch(context, injected);
    }

    public int fetchValue(JsonObjectContext context, int defaultValue) {
        Integer res = fetchValue(context);
        return res == null ? defaultValue : res;
    }
}
