package ru.yandex.autodoc.wmtools.params.fetch.json.primitive;

import ru.yandex.autodoc.wmtools.params.fetch.json.JsonObjectContext;
import ru.yandex.autodoc.wmtools.params.fetch.json.SimpleFieldView;
import ru.yandex.autodoc.wmtools.params.fetch.ParamHolder;

/**
 * @author avhaliullin
 */
public class LongFieldView extends SimpleFieldView<Long> {
    private final SimpleFieldView<Long> delegate;

    public LongFieldView(SimpleFieldView<Long> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ParamHolder<Long> fetch(JsonObjectContext context, Void injected) {
        return delegate.fetch(context, injected);
    }

    public long fetchValue(JsonObjectContext context, long defaultValue) {
        Long res = fetchValue(context);
        return res == null ? defaultValue : res;
    }
}
