package ru.yandex.autodoc.wmtools.util;

/**
 * @author avhaliullin
 */
public class Strings {
    public static String escapeXSS(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder((int) (s.length() * 1.1));

        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<':
                    sb.append("&lt;");
                    break;
                case '>':
                    sb.append("&gt;");
                    break;
                case '"':
                    sb.append("&quot;");
                    break;
                case '\'':
                    sb.append("&apos;");
                    break;
                default:
                    sb.append(c);
                    break;
            }
        }

        return sb.toString();
    }

    public static String normalizeSpaces(String s) {
        return s.replaceAll("\\s\\s+", " ");
    }
}
