package ru.yandex.autodoc.wmtools.view;

import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.springframework.beans.factory.annotation.Required;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
public class AbstractDocumentationHttpHandler extends ServletContextHandler {
    private final List<ServletNavigationInfo> servlets = new ArrayList<>();
    private String documentedEntity;

    public AbstractDocumentationHttpHandler() {
        addServlet(new ServletHolder(new HttpServlet() {
            @Override
            protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
                res.setContentType("text/html");
                res.setCharacterEncoding("utf-8");
                res.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");

                String title = "Документация - " + documentedEntity;

                res.getWriter().print("< !DOCTYPE HTML >\n" +
                        "< html >" +
                        "<head >" +
                        "<title >" + title + "</title >" +
                        "</head >" +
                        "<body >" +
                        "<h1 >" + title + "</h1 >" +
                        "<ul >" +
                        servlets.stream().map(s -> "<li><a href='" + s.path + "'>" + s.title + "</a></li>").collect(Collectors.joining("\n")) +
                        "</ul >" +
                        "</body >" +
                        "</html >");
            }
        }), "");
    }

    protected String getRootPath() {
        return "documentation";
    }

    protected String getProcessedRootPath() {
        return processPath(getRootPath(), true, true);
    }

    private String processPath(String path, boolean prefixSlash, boolean suffixSlash) {
        if (prefixSlash && !path.startsWith("/")) {
            path = "/" + path;
        } else if (!prefixSlash && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (suffixSlash && !path.endsWith("/")) {
            path = path + "/";
        } else if (!suffixSlash && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected void addDocumentationServlet(String title, String path, HttpServlet servlet) {
        addServlet(new ServletHolder(servlet), processPath(path, true, false));
        servlets.add(new ServletNavigationInfo(title, processPath(path, false, false)));
    }

    private static class ServletNavigationInfo {
        private final String title;
        private final String path;

        public ServletNavigationInfo(String title, String path) {
            this.title = title;
            this.path = path;
        }
    }

    @Required
    public void setDocumentedEntity(String documentedEntity) {
        this.documentedEntity = documentedEntity;
    }
}
