package ru.yandex.autodoc.wmtools.view;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.ErrorsDocumentationBuilder;
import ru.yandex.autodoc.common.doc.MethodsDocumentationBuilder;
import ru.yandex.autodoc.common.doc.view.handlers.ErrorsDocumentationHandler;
import ru.yandex.autodoc.common.doc.view.handlers.ErrorsDocumentationMarkuper;
import ru.yandex.autodoc.common.doc.view.handlers.MethodDocumentationHandler;
import ru.yandex.autodoc.common.doc.view.handlers.MethodDocumentationMarkuper;
import ru.yandex.autodoc.common.doc.view.handlers.ObjectFormatResolver;
import ru.yandex.autodoc.common.doc.view.renderers.HtmlRenderer;

/**
 * @author avhaliullin
 */
public class DocumentationHttpHandler extends AbstractDocumentationHttpHandler {
    private MethodsDocumentationBuilder methodsDocumentationBuilder;
    private ErrorsDocumentationBuilder errorsDocumentationBuilder;
    private ObjectFormatResolver objectFormatResolver;

    private MethodDocumentationHandler methodDocumentationHandler;
    private ErrorsDocumentationHandler errorsDocumentationHandler;

    public void init() {
        ErrorsDocumentationMarkuper errorsDocumentationMarkuper =
                new ErrorsDocumentationMarkuper(objectFormatResolver);
        methodDocumentationHandler = new MethodDocumentationHandler(
                new MethodDocumentationMarkuper(errorsDocumentationMarkuper, objectFormatResolver),
                methodsDocumentationBuilder
        );
        errorsDocumentationHandler = new ErrorsDocumentationHandler(
                new ErrorsDocumentationMarkuper(objectFormatResolver),
                errorsDocumentationBuilder
        );
        addDocumentationServlet(
                "Документация по методам",
                "methods",
                new MarkupServlet(HtmlRenderer.INSTANCE, methodDocumentationHandler)
        );
        addDocumentationServlet(
                "Документация по ошибкам",
                "errors",
                new MarkupServlet(HtmlRenderer.INSTANCE, errorsDocumentationHandler)
        );
    }

    @Required
    public void setMethodsDocumentationBuilder(MethodsDocumentationBuilder methodsDocumentationBuilder) {
        this.methodsDocumentationBuilder = methodsDocumentationBuilder;
    }

    @Required
    public void setErrorsDocumentationBuilder(ErrorsDocumentationBuilder errorsDocumentationBuilder) {
        this.errorsDocumentationBuilder = errorsDocumentationBuilder;
    }

    @Required
    public void setObjectFormatResolver(ObjectFormatResolver objectFormatResolver) {
        this.objectFormatResolver = objectFormatResolver;
    }
}
