var API = {
    baseAddress: "/api/rest/v1",
    apiCall: function (method, url) {
        return $.ajax({
            url: API.baseAddress + url,
            type: method
        })
            .fail(function (jqXHR, textStatus, errorThrown) {
                View.showAlert(errorThrown + ": " + jqXHR.responseText);
            });
    },
    listApplications: function () {
        return this.apiCall("GET", "/applications/");
    },
    listApplicationFeatures: function (appId) {
        return this.apiCall("GET", "/applications/" + appId + "/features");
    },
    getFeatureInfo: function (appId, featureId) {
        return this.apiCall("GET", "/applications/" + appId + "/features/" + featureId);
    },
    installFeature: function (appId, featureId) {
        return this.apiCall("POST", "/applications/" + appId + "/features/" + featureId + "/install");
    },
    destroyFeature: function (appId, featureId) {
        return this.apiCall("POST", "/applications/" + appId + "/features/" + featureId + "/destroy");
    },
    createFeature: function (appId, featureId){
        return this.apiCall("POST", "/applications/" + appId + "/features/" + featureId + "/create");
    }
};