var FeatureInfo = {
    appId: null,
    featureId: null,
    loadFeatureInfo: function () {
        var appId = FeatureInfo.appId;
        var featureId = FeatureInfo.featureId;

        var inElem = $("#content");
        inElem.empty();
        var processing = View.createProcessing(inElem);
        API.getFeatureInfo(appId, featureId)
            .always(function () {
                processing.remove();
            })
            .done(function (data) {
                FeatureInfo.displayFeatureInfo(data, inElem)
            });
    },
    displayFeatureInfo: function (data, inElem) {
        var appId = FeatureInfo.appId;
        var featureId = FeatureInfo.featureId;

        var installButton = View.createButton("Установить", function (event) {
            var self = $(event.target);
            if (!self.hasClass("disabled")) {
                self.addClass("disabled");
                var p = View.createProcessing(self);
                API.installFeature(appId, featureId)
                    .always(function () {
                        p.remove();
                        self.removeClass("disabled");
                    })
                    .done(function () {
                        View.showInfo("Установлено");
                        FeatureInfo.loadFeatureInfo();
                    });
            }
        });
        inElem.append(View.createKeyValue("Приложение", appId));
        inElem.append(View.createKeyValue("Доступный артефакт", data.artifact === null ? "Отсутствует" :
            View.createText(data.artifact.modifiedDate + " ").add(installButton)));
        inElem.append(View.createKeyValue("Дата сборки текущей версии",
            data.feature.artifactBuildDate === null ? "Отустствует" : data.feature.artifactBuildDate));
        inElem.append(View.createKeyValue("Состояние контейнера", data.container === undefined ? "Отсутствует" : data.container['state']));
        if (data.sshString != null) {
            inElem.append(View.createKeyValue("Подключиться к контейнеру", View.createCopyInput(data.sshString)));
        }
        inElem.append(View.createButton("Выключить фичу", function (event) {
            var self = $(event.target);
            if (!self.hasClass("disabled")) {
                self.addClass("disabled");
                var p = View.createProcessing($(event.target));
                API.destroyFeature(appId, featureId)
                    .always(function () {
                        p.remove();
                        self.removeClass("disabled");
                    })
                    .done(function () {
                        View.showInfo("Фича выключена");
                        View.redirectTo(Paths.featuresList(FeatureInfo.appId));
                    });
            }
        }));
    },
    init: function (appId, featureId) {
        FeatureInfo.appId = appId;
        FeatureInfo.featureId = featureId;
        FeatureInfo.loadFeatureInfo();
    }
};
