var FeaturesList = {
    appId: null,
    loadApplicationFeatures: function () {
        var inElem = $("#content");
        inElem.empty();
        var input = $('<input type="text" name="feature" id="feature">');
        input.keypress(function (e) {
            if (e.which == 13) {
                FeaturesList.onFeatureAdd();
            }
        });
        inElem.append(input);
        inElem.append("&nbsp;");
        var addButton = View.createButton("Добавить фичу", FeaturesList.onFeatureAdd);
        inElem.append(addButton);
        inElem.append("<h4>Список фич:</h4>");
        var processing = View.createProcessing(inElem);
        API.listApplicationFeatures(FeaturesList.appId)
            .always(function () {
                processing.remove();
            })
            .done(function (data) {
                var appsList = View.createList(inElem);
                data.map(
                    function (featureInfo) {
                        appsList.addItem(View.makeLink(featureInfo.featureId, Paths.featureInfo(FeaturesList.appId, featureInfo.featureId)));
                    }
                );
            });

    },

    onFeatureAdd: function (event) {
        var self = $(event.target);
        if (!self.hasClass("disabled")) {
            self.addClass("disabled");
            var featureId = $("#feature").val();
            if (featureId) {
                var p = View.createProcessing(self);
                API.createFeature(FeaturesList.appId, featureId)
                    .always(function () {
                        self.removeClass("disabled");
                        p.remove();
                    })
                    .done(function () {
                        View.showInfo("Фича добавлена");
                        FeaturesList.loadApplicationFeatures();
                    });
            }
        }
    },
    init: function (appId) {
        this.appId = appId;
        this.loadApplicationFeatures();
    }
};