var Paths = {
    applicationsList: "#applications-list",
    featuresList: function (appId) {
        return "#features-list(" + appId + ")";
    },
    featureInfo: function (appId, featureId) {
        return "#feature-info(" + appId + "," + featureId + ")";
    },

    PAGE_APP_LIST: "applist",
    PAGE_FEATURES_LIST: "featureslist",
    PAGE_FEATURE_INFO: "featureinfo",
    getPageInfo: function () {
        var hash = window.location.hash;
        var flResult = hash.match(/^#features-list\((.+)\)$/);
        if (flResult) {
            var appId = flResult[1];
            return {
                "page": this.PAGE_FEATURES_LIST,
                "title": appId + " - список фич",
                "appId": appId,
                "breadcrumbs": [{
                    "text": "Список приложений",
                    "href": this.applicationsList
                }, {
                    "text": appId
                }]
            };
        }
        var fiResult = hash.match(/^#feature-info\((.+),(.+)\)$/);
        if (fiResult) {
            var appId = fiResult[1];
            var featureId = fiResult[2];
            return {
                "page": Paths.PAGE_FEATURE_INFO,
                "title": "Приложение " + appId + ", фича " + featureId,
                "appId": appId,
                "featureId": featureId,
                "breadcrumbs": [{
                    "text": "Список приложений",
                    "href": this.applicationsList
                }, {
                    "text": appId,
                    "href": Paths.featuresList(appId)
                }, {
                    "text": featureId
                }]
            }
        }
        return {
            "page": this.PAGE_APP_LIST,
            "title": "Список приложений",
            "breadcrumbs": [{"text": "Список приложений"}]
        };
    }
};
