var View = {
    notification: function (message, color) {
        var notifications = $("#notifications");
        if (!notifications.length) {
            notifications = $("<div id='notifications' class='notifications-area'></div>");
            $("body").append(notifications);
        }
        var close = $("<div class='notification-close'>X</div>");

        var notification = $("<div class='notification'></div>'");
        notification.css("background-color", color);
        notification.append(close);
        notification.append(message);
        close.click(function () {
            notification.remove();
        });
        notifications.append(notification);
    },
    showAlert: function (message) {
        this.notification(message, "rgb(253, 206, 186)");
    },
    showInfo: function (message) {
        this.notification(message, "rgb(184, 255, 179)");
    },
    createTable: function (inElement) {
        var html = "<table><thead>";
        for (var i = 0; i < arguments.length; i++) {
            html = html + "<th>" + arguments[i] + "</th>";
        }
        html = html + "</thead><tbody></tbody></table>";
        var tableJq = $(html);
        inElement.append(tableJq);
        return {
            body: tableJq.children("tbody"),
            addRow: function () {
                var tr = $("<tr></tr>");
                for (var i = 0; i < arguments.length; i++) {
                    var td = $("<td></td>");
                    td.append(arguments[i]);
                    tr.append(td);
                }
                this.body.append(tr);
            }
        };
    },
    createList: function (inElement) {
        var html = $("<ul></ul>");
        inElement.append(html);
        return {
            list: html,
            addItem: function (item) {
                var li = $("<li></li>");
                li.append(item);
                this.list.append(li);
            }
        }
    },
    createProcessing: function (inElement) {
        var html = $("<div class='processing'>Loading...</div>");
        inElement.append(html);
        return html;
    },
    makeLink: function (content, url) {
        var result = $("<a href=" + url + "></a>");
        result.append(content);
        return result;
    },
    createKeyValue: function (key, value) {
        var p = $("<p></p>");
        var kElem = $("<b></b>");
        p.append(kElem);
        kElem.append(key);
        p.append("&nbsp;");
        p.append(value);
        return p;
    },
    createText: function (text) {
        return $(document.createTextNode(text));
    },
    createButton: function (content, onclick) {
        var result = $("<span class='button'></span>");
        result.append(content);
        result.click(onclick);
        return result;
    },
    createLink: function (content, href) {
        var a = $("<a href='" + href + "'></a>");
        a.append(content);
        return a;
    },
    setTitle: function (title) {
        $(".title").text(title);
    },
    redirectTo: function (location) {
        window.location = location;
    },
    showBreadcrumbs: function (items) {
        var bc = $(".breadcrumb");
        bc.empty();
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            var link = $("<a></a>");
            if (item.href != null) {
                link.attr("href", item.href);
            }
            link.text(item.text);
            var li = $("<li></li>");
            li.append(link);
            bc.append(li);
        }
    },
    createCopyInput: function(text) {
        var input = $("<input type='text' readonly class='copy-input'>");
        input.attr("value", text);
        input.click(function(){
            this.select();
        });
        return input;
    }
};