package ru.yandex.featurer

import akka.actor.ActorSystem
import akka.routing.FromConfig
import org.slf4j.LoggerFactory
import ru.yandex.featurer.controller.ControllersComponent
import ru.yandex.featurer.error.UserException
import ru.yandex.featurer.service._
import ru.yandex.featurer.utils.{CustomDirectives, HttpHandlerActor}
import ru.yandex.featurer.utils.application.{HttpRouterComponent, SprayApplication}
import spray.routing.ExceptionHandler
import _root_.spray.routing.HttpService._
import ru.yandex.autodoc.spray.rest._

/**
 * @author avhaliullin
 */
object Main extends SprayApplication
with HttpRouterComponent
with ApplicationsServiceComponent
with TeamcityServiceComponent
with ContainerServiceComponent
with NginxServiceComponent
with OperationsServiceComponent
with ControllersComponent {
  def configResource = "viewer"

  private val log = LoggerFactory.getLogger(getClass)

  val actorSystem = ActorSystem("featurer", config)


  val errorHandle = ExceptionHandler {
    case ue: UserException => complete(404 -> ue.message)
  }

  val httpRouter = actorSystem.actorOf(
    HttpHandlerActor.props(
      pathPrefix("documentation" / "methods.html")(restDoc(restHandle)) ~
        (CustomDirectives.logRequest(log) & handleExceptions(errorHandle) & pathPrefix("rest" / "v1")) {
          restRoute(restHandle)
        }
    ).withRouter(FromConfig()),
    "http-handler")

  val applicationsService = new ApplicationsService(config("applications"))
  val teamcityService = new TeamcityService(config("teamcity"))
  val containerService = new ContainerService(config("lxc"), config("teamcity"))
  val nginxService = new NginxService(config("nginx"))
  val operationsService = new OperationsService(config("featurer"))

  operationsService.startAll()
}
