package ru.yandex.featurer.controller

import ru.yandex.autodoc.spray.common.res.Json
import ru.yandex.featurer.data.{ApplicationFeatureInfo, TeamcityArtifactInfo, ContainerInfo, ApplicationInfo}

/**
 * @author avhaliullin
 */
case class ApplicationFeatureView(application: ApplicationInfo, featureInfo: ApplicationFeatureInfo,
                                  container: Option[ContainerInfo], artifact: Option[TeamcityArtifactInfo],
                                  sshString: Option[String])

object ApplicationFeatureView {
  implicit val renderer = Json.Object[ApplicationFeatureView](
    "application" -> Json.field(_.application),
    "feature" -> Json.field(_.featureInfo),
    "container" -> Json.field(_.container),
    "artifact" -> Json.field(_.artifact),
    "sshString" -> Json.field(_.sshString)
  )
}
